<?php
class LoggedUser extends User {
	protected $contacts = array();
	protected $_last_session = null;
	
	public function __construct($id = null, $login = null, $pass = null){
	  parent::__construct($id);
	  
	  // try to find user by username and password
	  if(($id === null) AND empty($this->id)){
      $this->set_info(current($this->db->select(
        array(), array("users"), '*', array('goperator' => 'and', array("login", "=", "'$login'"), array('pass', '=', "'$pass'"))
      )));
	  }
	  
		$this->load_contacts();
	}

	public function is_logged_in(){
	  // check if user is already logged in
    $this->_last_session = $this->db->select(array(), array("sessions"), '*', 
      array('goperator' => 'and', 
        array('id_user', '=', $this->get_id()),
        array('sid', '=', "'" . session_id() . "'"), 
        array('logout_time', 'IS', 'NULL'), 
        array('last_action_time', '>', "'" . date('Y-m-d H:i:s', time() - SESSION_TIMEOUT) . "'")
      ),
      array('count' => 1, 'offset' => 0)
    );
        
    return (!empty($this->_last_session));
	}
	
	public function update_session(){
    // session already exists - update it
    if($this->is_logged_in()){
      $this->db->update(array(), 'sessions', array('last_action_time' => '{NOW()}'), array('goperator' => 'and', array('id', '=', $this->_last_session['id'])));
      return true;
    }
    
    // save new session information
    $sid = $this->db->insert(array(), 'sessions', array('id_user' => $this->get_id(), 'ip' => $_SERVER['REMOTE_ADDR'], 'sid' => session_id(), 'last_action_time' => '{NOW()}'));
    
    if(empty($sid)){
      throw new RequestException("Failed to create session.", Request::ERROR_UNKNOWN);    
    } else {
      return true;
    }
	}

	public function logout(){
	  if(!$this->is_logged_in()) return true;
    // session already exists - update it
    if(!$this->db->update(array(), 'sessions', array('logout_time' => '{NOW()}', 'logout_reason' => 'manual'), array('goperator' => 'and', array('id', '=', $this->_last_session['id'])))){
      throw new RequestException('Failed to log user out', Request::ERROR_UNKNOWN);
    }
    
    return true;
	}
	
	public function get_contacts(){
	  $result = array();
	  
	  foreach($this->contacts as $id_user_contact => $contact){
	    $result[$id_user_contact] = $contact->get_info();
	  }
	  
	  return $result;
	}
	
	public function has_contact($id_contact){
		$this->load_contacts();
		return isset($this->contacts[$id_contact]);
	}
	
	public function remove_contact($id_contact){
		if(!$this->has_contact($id_contact)) return;
    if(!$this->db->delete(array(), "contacts", array("goperator" => "and", array("id_user", '=', $this->id), array('id_user_contact', '=', $id_contact)))){
      throw new RequestException("Kontakt sa nepodarilo vymazať", Request::ERROR_UNKNOWN);
    }
    if(!$this->db->delete(array(), "contacts", array("goperator" => "and", array("id_user", '=', $id_contact), array('id_user_contact', '=', $this->id)))){
      throw new RequestException("Kontakt sa nepodarilo vymazať", Request::ERROR_UNKNOWN);
    }
    $this->load_contacts();   
	}
	
	public function add_contact($id_contact){
    if($this->has_contact($id_contact)) return;
    if(!$this->db->insert(array(), "contacts", array('id_user' => $this->id, 'id_user_contact' => $id_contact, 'time_added' => '{NOW()}'))){
      throw new RequestException("Kontakt sa nepodarilo pridať", Request::ERROR_UNKNOWN);
    }
    
    // vlozime sa aj pridavanemu kontaktu
    // asi by sa to malo riesit potvrdzovanim
    $_tmp = $this->db->select(array(), array("contacts"), '*', array('goperator' => 'and', array("id_user", '=', $id_contact), array("id_user_contact", '=', $this->id)));
    
    // ak este nebol pridany
    if(empty($_tmp)){
	    if(!$this->db->insert(array(), "contacts", array('id_user_contact' => $this->id, 'id_user' => $id_contact, 'time_added' => '{NOW()}'))){
	      throw new RequestException("Kontakt sa nepodarilo pridať", Request::ERROR_UNKNOWN);
	    }
    }
    $this->load_contacts();   
	}
	
	protected function load_contacts(){
		$list = $this->db->select(array(), array("contacts"), '*', array('goperator' => 'and', array("id_user", '=', $this->id)));
		
		$this->contacts = array();
		foreach($list as $row){
			$this->contacts[$row['id_user_contact']] = new Contact($row['id_user_contact'], $row['alias']);
		}
	}
	
	protected function save_contacts(){
		foreach($this->contacts as $contact){
			$insert = array('id_user' => $this->id, 'id_user_contact' => $contact->id, 'alias' => $contact->alias, 'time_added' => empty($contact->time_added) ? date('Y-m-d H:i:s') : $contact->time_added);
			$on_duplicate_update = array('alias' => $insert['alias']);
			$this->db->insert(array(), "contacts", $insert, $on_duplicate_update);
		}
	}
	
	
}
?>